### 概述

本产品是一款高性能的运动控制工具，提供高效、精确的 XYZ 三轴连续插补和避障功能，旨在优化路径规划和提高运动控制的安全性。该库适用于多轴运动控制，尤其是在复杂环境中执行精密任务时，能够有效避免碰撞并确保最优路径。

库实现了从起始位置到目标位置的多段连续轨迹插补，支持设置每段插补的速度、加速度、减速度等参数。若未明确设置参数，则会使用默认值进行插补。提供了T形和S形加减速选项及灵活的过渡曲线类型，确保运动的平滑性与精确性。

避障功能适用于 XYZ 直角坐标系的机器人设备。障碍物的尺寸和位置通过虚拟障碍物模型定义，库支持设定安全边距和障碍物的上下表面高度，机器人根据设定的高度和距离调整 Z 轴运动，确保避免障碍物的干扰，安全到达目标位置。

下表概述了各个产品组件

| **产品组件**            | **描述说明**   |
| ------------------- | ---------- |
| FB\_InterpolatorXYZ | XYZ 三轴连续插补 |
| FB\_PickBond        | 避障功能       |

---

### 安装卸载

**安装要求**

本节描述工程和/或运行时系统所需的最低要求。

**1、硬件要求**

支持 MetaFacture 平台的设备（ PLC 或嵌入式系统）。

**2、软件要求**

已安装 MetaFacture 的开发环境。

操作系统支持：MetaOS或其他兼容平台。

必须具备相关的库或模块依赖（如基础 I/O 库）

**安装过程**

根据 **ZDSKInterpolator&#x20;**&#x7248;本和使用的操作系统，产品可以通过不同的方式安装，下面将详细介绍。

在 MetaFacture 中打开工程项目。

通过菜单选择“工具”->“库存储”。
![](https://resource.helplook.net/docker_production/3648ne/article/5ZCxM8pS/680ef8adbd1a4.png)



点击安装，打&#x5F00;**&#x20;ZDSKInterpolator** 库文件。

点击”添加库“
![](https://resource.helplook.net/docker_production/3648ne/article/5ZCxM8pS/680ef8b8e3f56.png)



选&#x4E2D;**&#x20;ZDSKInterpolator&#x20;**，点击确&#x5B9A;**。**


**更新安装**

**1、覆盖安装**

下载最新版本的 ZDSKInterpolator 库文件。

打开 MetaFacture 工程，在“库管理器”中删除旧版本的库，导入新版本库文件。

保存工程并重新编译。

**2、版本兼容性验证**

检查新版本是否与现有工程兼容（例如检查参数和接口）。

根据文档调整旧版本与新版本可能的差异。

**卸载过程**

**1、通过库管理器卸载**

打开 MetaFacture 项目，进入“库管理器”。

选择 ZDSKInterpolator 库，点击“删除库”卸载库文件。

2、**清理项目依赖**

打开工程项目，检查并移除所有使用 ZDSKInterpolator 库的功能块或接口。

确保工程重新编译时无报错。

---
### **XYZ三轴连续插补功能**

以功能块启动时的 X、Y，Z轴位置为起点，已知后续多段连续轨迹坐标，实现从起点到终点的三轴连续插补。

每段插补的速度，加速度，减速度，加加速度可以在指令结构体数组中单独设置，若不设置或输入0则采用默认参数结构体中对应的默认参数。

可选 T形/S 形加减速 ，及直线间的过渡曲线类型，可在默认参数结构体中设置相应的参数。

**使用要求**

| 开发环境        | 目标平台 | 需要包含的**PLC 库**   |
| ----------- | ---- | ---------------- |
| MetaFacture | PC   | ZKSDInterpolator |

---
### 避障功能

避障功能适用于XYZ直角坐标系机器人设备。

pickbond从pick点到bond点只允许单个长方体障碍物且长宽高与XYZ坐标轴平行。

pick点和bond点按照实际设备伺服读到的位置设置。

pickbond认为障碍物沿着X轴正方向和负方向都无限长，沿着Z轴负方向无限长，即Z轴值增大才能远离障碍物。

设置虚拟障碍物，两个角点位置，负角点3个坐标值必须分别小于正角点的3个坐标值，以确定障碍物位置和尺寸。

角点坐标值来自实际设备伺服读到的位置来比较，最小的值作为负角点，最大的值作为正角点。

障碍物的上表面高度设置必须高于起pick点和Bond点的高度Z。

障碍物要包裹住关键部分，如图。
![](https://resource.helplook.net/docker_production/3648ne/article/qgxTJ4Ad/680ef877c5d6e.png)


高度fHeightOverObstacle，指定Z轴超过障碍物上表面的高度，Z轴向上运动到此高度停止并反向运动。

在其他条件允许时，最优时间路径会与障碍物边缘非常接近，示意图如下左图，变量safe\_margin，作用是远离障碍物，示意图如下右图。

![](https://resource.helplook.net/docker_production/3648ne/article/qgxTJ4Ad/680ef87ea5605.png)


在pick点运动后，顶针轴和Z轴先同步运动一段很小的距离，同步运动结束后，Z轴位置不会超过障碍物上表面加fHeightOverObstacle。随后顶针轴减速到零，并回到设定的起始点。XYZ轴避开障碍物运动到Bond点。

**使用要求**

| 开发环境        | 目标平台 | 需要包含的**PLC 库**   |
| ----------- | ---- | ---------------- |
| MetaFacture | PC   | ZKSDInterpolator |